<?php

/*
  Template Name: Contact
 */

get_header();
?>


<?php
$post_id = get_the_ID();
$featured_image_url = get_the_post_thumbnail_url($post_id, 'full');
$banner_url = $featured_image_url;

if ($banner_url == '') {
    $banner_url = get_field('common_banner_image', 'options')['url'];
}
?>
<section class="banner bg-cover bg-no-repeat flex h-[21rem] items-center relative w-full" style="background: url(<?php echo $banner_url; ?>) no-repeat;background-position: top;background-size: cover;">
    <div class="container relative top-[-1.5rem]">
        <div class="flex justify-center items-center">
            <div class="text-center flex flex-wrap flex-col">
                <h1 class="mb-3 font-bold text-4xl xl:text-5xl 2xl:text-7xl text-white uppercase leading-none"><?php echo get_the_title(); ?></h1>
            </div>
        </div>
    </div>
</section>


<?php
echo do_shortcode('[custom_breadcrumbs]');
?>


<section class="py-space contact-main">
    <div class="container">
        <div class="flex flex-wrap gap-y-7">
            <div class="w-full lg:w-[70%] md:pr-8">
                <?php
                echo do_shortcode('[contact-form-7 id="b736648" title="Request Quote"]');
                ?>
            </div>

            <div class="w-full lg:w-[30%]">
                <div class="bg-secondary p-6 xl:p-8 rounded-xl">
                    <h3 class="text-2xl mb-4">Get In Touch</h3>
                    <ul class="flex flex-wrap flex-col mb-3 gap-y-2">
                        <?php if (get_field('contact_page_details', 'options')['email'] != '') { ?>
                            <li class="flex items-center gap-3"><img src="<?php echo get_template_directory_uri() . '/assets/images/mail-icon.png'; ?>" alt="mail-icon" /><a class="text-black" href="mailto:<?php echo get_field('contact_page_details', 'options')['email']; ?>"><?php echo get_field('contact_page_details', 'options')['email']; ?></a></li>
                        <?php } ?>

                        <?php if (get_field('contact_page_details', 'options')['phone'] != '') { ?>
                            <li class="flex items-center gap-3"><img src="<?php echo get_template_directory_uri() . '/assets/images/phone-icon.png'; ?>" alt="phone-icon" /><a class="text-black" href="tel:<?php echo get_field('contact_page_details', 'options')['phone']; ?>"><?php echo get_field('contact_page_details', 'options')['phone']; ?></a></li>
                        <?php } ?>

                        <?php if (get_field('contact_page_details', 'options')['address'] != '') { ?>
                            <li class="flex gap-3 items-start">
                                <img class="w-4 mt-4" src="<?php echo get_template_directory_uri() . '/assets/images/location-icon.svg'; ?>" alt="location-icon" />
                                <a class="text-black leading-normal">
                                    <?php echo get_field('contact_page_details', 'options')['address']; ?>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>

                    <?php if (have_rows('contact_social_details', 'options')) { ?>
                        <div class="social">
                            <h2 class="text-black block font-semibold mb-2 text-lg">Follow us on</h2>
                            <ul class="flex items-center gap-5">
                                <?php
                                while (have_rows('contact_social_details', 'options')) : the_row();
                                    $social_media_icon = get_sub_field('social_media_icon');
                                    $social_media_link = get_sub_field('social_media_link');
                                ?>
                                    <li><a href="<?php echo $social_media_link; ?>"><img src="<?php echo $social_media_icon['url']; ?>" alt="<?php echo $social_media_icon['alt']; ?>" /></a></li>
                                <?php endwhile; ?>
                            </ul>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
get_footer();
?>