<?php
get_header();
?>

<section class="banner-detail">
    <?php
    $company_images = get_field('company_images');
    if ($company_images) {
    ?>
        <div class="owl-carousel owl-theme vs-update-slider">
            <?php
            foreach ($company_images as $key => $company_image) {
            ?>
                <div class="item">
                    <figure class="aspect-square">
                        <img src="<?php echo esc_url($company_image['url']); ?>" class="w-full object-cover h-full aspect-square" alt="<?php echo esc_attr($company_image['alt']); ?>" />
                    </figure>
                </div>
            <?php
            } ?>
        </div>
    <?php
    } ?>
</section>

<?php
echo do_shortcode('[custom_breadcrumbs]');
?>


<section class="py-space pt-0">
    <div class="container">
        <div class="flex flex-wrap justify-start md:justify-between items-center border-b border-gray-dark pb-8 mb-11">
            <div class="flex flex-wrap">
                <h2 class="text-2xl font-bold text-black w-full mb-2"><?php the_title(); ?></h2>
                <div class="flex flex-wrap items-center gap-1 md:gap-6 mb-3 sm:mb-0">
                    <div class="flex items-center gap-2"><img class="w-3" src="<?php echo get_template_directory_uri() . '/assets/images/location-icon.svg'; ?>" alt="location-icon" />
                        <p><?php echo get_field('city') . ', ', get_field('state'); ?></p>
                    </div>

                    <?php
                    $company_id = get_the_ID(); // Assuming this is inside the single company template

                    $args = [
                        'post_type'      => 'review',
                        'post_status'    => 'publish',
                        'posts_per_page' => -1,
                        'meta_query'     => [
                            [
                                'key'   => 'company_id',
                                'value' => $company_id,
                                'compare' => '='
                            ]
                        ]
                    ];

                    $reviews = get_posts($args);
                    $total_reviews = count($reviews);
                    $total_rating = 0;

                    foreach ($reviews as $review) {
                        $rating = get_post_meta($review->ID, 'rating', true);
                        $total_rating += intval($rating);
                    }

                    $average_rating = $total_reviews > 0 ? round($total_rating / $total_reviews, 1) : 0;

                    // Convert average rating (out of 5) to percentage for width
                    $filled_width = ($average_rating / 5) * 100;
                    ?>


                    <div class="flex items-center gap-2 font-semibold text-sm">
                        <div class="stars text-gray-dark flex">
                            <div class="rating-stars relative">
                                <div class="empty stars text-gray-dark flex">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                </div>
                                <div class="filled stars text-primary flex absolute top-0 left-0 overflow-hidden w-[30%]" style="width: <?php echo $filled_width; ?>%">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                </div>
                            </div>
                        </div>
                        <a href="#customer_reviews"><?php echo $total_reviews; ?> Review<?php echo $total_reviews === 1 ? '' : 's'; ?></a>
                    </div>
                </div>
            </div>
            <a href="<?php echo site_url('contact'); ?>" class="btn btn-transparent">
                Contact us
            </a>
        </div>
        <main class="flex flex-wrap gap-y-7">
            <div class="w-full lg:w-[70%] md:pr-10">
                <div class="mb-8 xl:mb-12">
                    <h2 class="text-2xl mb-4 xl:mb-6">What we offer</h2>
                    <p class="text-gray-600 mb-4 xl:mb-6">
                        <?php echo get_field('company_description'); ?>
                    </p>
                    <?php
                    $terms = get_the_terms(get_the_ID(), 'item_category');
                    if (! is_wp_error($terms) && ! empty($terms)) :
                    ?>
                        <ul class="grid grid-cols-1 sm:grid-cols-2 gap-y-3 mb-6">
                            <?php foreach ($terms as $term) : ?>
                                <li class="flex items-center gap-x-3"><img src="<?php echo get_template_directory_uri() . '/assets/images/check-circle.svg'; ?>" alt="check-circle" /> <?php echo esc_html($term->name); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endif; ?>
                    <p><?php echo get_field('company_short_description'); ?></p>
                </div>
                <div class="mb-8 xl:mb-12">
                    <h2 class="text-2xl mb-4 xl:mb-6">Tags</h2>
                    <?php
                    $terms_tags = get_the_terms(get_the_ID(), 'item_tag');
                    if (! is_wp_error($terms_tags) && ! empty($terms_tags)) :
                    ?>
                        <div class="flex flex-wrap gap-2">
                            <?php foreach ($terms_tags as $term) : ?>
                                <span class="btn btn-transparent border-gray-dark min-w-[7rem]"><?php echo esc_html($term->name); ?></span>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div>
                    <?php
                    $clients_and_portfolios = get_field('clients_and_portfolios');
                    if ($clients_and_portfolios) {
                    ?>
                        <h2 class="text-2xl mb-4 xl:mb-6"><?php the_title(); ?> Clients & Portfolios</h2>
                        <div class="grid grid-cols-2 md:grid-cols-3 gap-2 md:gap-4 mb-6">
                            <?php
                            foreach ($clients_and_portfolios as $key => $client_and_portfolio) {
                            ?>
                                <figure class="mx-auto border border-gray-dark rounded-lg w-full flex items-center p-5">
                                    <img class="mx-auto" src="<?php echo esc_url($client_and_portfolio['url']); ?>" alt="<?php echo esc_attr($client_and_portfolio['alt']); ?>" />
                                </figure>
                            <?php
                            } ?>
                        </div>

                        <div class="flex items-center">
                            <a href="#" class="text-sm font-semibold text-black">View All Portfolio</a>
                            <img class="w-2 ms-1" src="<?php echo get_template_directory_uri() . '/assets/images/right-a.png'; ?>" alt="right-a" />
                        </div>
                    <?php
                    } ?>
                </div>


                <div class="customer-review mt-10 xl:mt-12 relative" id="customer_reviews">
                    <?php
                    $company_id = get_the_ID(); // We're on single-company.php

                    $reviews = get_posts([
                        'post_type' => 'review',
                        'meta_query' => [
                            [
                                'key' => 'company_id',
                                'value' => $company_id,
                                'compare' => '='
                            ]
                        ],
                        'posts_per_page' => 20, // Adjust if needed
                        'post_status' => 'publish'
                    ]);

                    if (!empty($reviews)) :
                    ?>
                        <h2 class="text-2xl mb-4 xl:mb-6">Customer Reviews</h2>
                    <?php
                        echo '<div class="owl-carousel double-row-carousel">';

                        for ($i = 0; $i < count($reviews); $i += 2) {
                            echo '<div class="item-group flex flex-wrap gap-y-5 flex-col">';

                            for ($j = 0; $j < 2; $j++) {
                                $index = $i + $j;
                                if (!isset($reviews[$index])) break;

                                $review = $reviews[$index];

                                $full_name = get_post_meta($review->ID, 'reviewer_name', true);
                                $rating = intval(get_post_meta($review->ID, 'rating', true));
                                $title = esc_html($review->post_title);
                                $content = esc_html($review->post_content);
                                $date = human_time_diff(get_the_time('U', $review), current_time('timestamp')) . ' ago';
                                $user_id = get_post_meta($review->ID, 'current_user_id', true);
                                $user_profile_pic_id = get_user_meta($user_id, 'user_registration_profile_pic_url', true);

                                if (is_numeric($user_profile_pic_id)) {
                                    $img_data = wp_get_attachment_image_src($user_profile_pic_id, 'thumbnail');
                                    $user_profile_pic_src = $img_data ? $img_data[0] : '';
                                } else {
                                    $user_profile_pic_src = $user_profile_pic_id; // assume it's a URL
                                }

                                if (empty($user_profile_pic_src)) {
                                    $user_profile_pic_src = '/wp-content/uploads/2025/05/wp-placeholder.jpg';
                                }

                                echo '<div class="review-item">
                                        <div class="flex items-start space-x-6 bg-white">
                                            <div class="text-center text-sm text-black col-left">
                                                <img class="w-auto rounded-full mb-2" src="' . esc_url($user_profile_pic_src) . '" alt="' . esc_attr($full_name) . '" class="w-12 h-12 rounded-full object-cover">
                                                <p>' . esc_html($full_name) . '</p>
                                            </div>
                                            <div class="flex flex-col gap-y-2 p-6 rounded-xl border border-gray-dark col-right">
                                                <h6 class="font-bold text-lg leading-none mb-1">“' . $title . '”</h6>
                                                <div class="stars text-primary flex text-[15px]">';

                                for ($s = 1; $s <= 5; $s++) {
                                    echo '<i class="' . ($s <= $rating ? 'fas' : 'far') . ' fa-star"></i>';
                                }

                                echo '</div>
                                                <p>' . $content . '</p>
                                                <p class="text-sm">' . $date . '</p>
                                            </div>
                                        </div>
                                    </div>';
                            }

                            echo '</div>';
                        }

                        echo '</div>';

                    endif;
                    ?>
                    <?php if (is_user_logged_in()) : ?>
                        <div class="review-btn mt-6 xl:mt-10">
                            <button onclick="toggleForm()" class="btn bg-primary transition">Write your review</button>
                        </div>
                    <?php endif; ?>

                    <div id="reviewForm" class="transition-max opacity-0 scale-95 mt-6 hidden transition-all duration-500 rounded-lg">
                        <form class="space-y-3 flex flex-col">
                            <div>
                                <?php
                                $current_user = wp_get_current_user();

                                $first_name = $current_user->user_firstname;
                                $last_name  = $current_user->user_lastname;

                                // Full name
                                $full_name = trim($first_name . ' ' . $last_name);
                                ?>
                                <label for="full_name" class="mb-1 block text-black">Full Name</label>
                                <input id="full_name" type="text" name="full_name" placeholder="Full Name" class="w-full px-2 py-2 rounded-md text-gray border-gray-dark border outline-none bg-secondary pointer-events-none" readonly value="<?php echo $full_name; ?>" />
                            </div>
                            <div>
                                <label for="rating" class="mb-1 block text-black">Rating</label>
                                <div class="rating">
                                    <input type="radio" id="star1" name="rating" value="5" />
                                    <label class="fas fa-star" for="star1" title="Awesome" aria-hidden="true"></label>
                                    <input type="radio" id="star2" name="rating" value="4" />
                                    <label class="fas fa-star" for="star2" title="Great" aria-hidden="true"></label>
                                    <input type="radio" id="star3" name="rating" value="3" />
                                    <label class="fas fa-star" for="star3" title="Very Good" aria-hidden="true"></label>
                                    <input type="radio" id="star4" name="rating" value="2" />
                                    <label class="fas fa-star" for="star4" title="Good" aria-hidden="true"></label>
                                    <input type="radio" id="star5" name="rating" value="1" />
                                    <label class="fas fa-star" for="star5" title="Bad" aria-hidden="true"></label>
                                </div>
                            </div>
                            <div>
                                <label for="your_title" class="mb-1 block text-black">Title</label>
                                <input id="your_title" type="text" name="your_title" placeholder="Your Title" class="w-full px-2 py-2 rounded-md text-black border-gray-dark border outline-none" required />
                            </div>
                            <div>
                                <label for="reviewText" class="mb-1 block text-black">Your Review</label>
                                <textarea name="reviewText" id="reviewText" class="w-full border outline-none text-black border-gray-dark rounded p-2" rows="4" placeholder="Write something..."></textarea>
                            </div>
                            <input type="hidden" name="company_id" value="<?php echo get_the_ID(); ?>">
                            <input type="hidden" name="current_user_id" value="<?php echo get_current_user_id(); ?>">
                            <div class="submit-btn">
                                <button type="button" onclick="submitReview(event)" class="btn bg-primary transition">
                                    Submit
                                </button>
                            </div>
                        </form>
                        <p class="response-message text-sm font-medium mt-2 hidden"></p>
                    </div>
                </div>

            </div>
            <div class="w-full lg:w-[30%]">
                <aside class="space-y-6">
                    <div class="bg-secondary p-6 xl:p-8 rounded-xl">
                        <h3 class="text-2xl mb-4">Get In Touch</h3>
                        <ul class="flex flex-wrap flex-col mb-3 gap-y-2">
                            <li class="flex items-center gap-3"><img src="<?php echo get_template_directory_uri() . '/assets/images/mail-icon.png'; ?>" alt="mail-icon" /><a class="text-black" href="mailto:<?php echo get_field('contact_details')['email']; ?>"><?php echo get_field('contact_details')['email']; ?></a></li>
                            <li class="flex items-center gap-3"><img src="<?php echo get_template_directory_uri() . '/assets/images/phone-icon.png'; ?>" alt="phone-icon" /><a class="text-black" href="tel:<?php echo get_field('contact_details')['phone']; ?>"><?php echo get_field('contact_details')['phone']; ?></a></li>
                        </ul>
                        <div class="socail">
                            <h2 class="text-black block font-semibold mb-2 text-lg">Follow us on</h2>
                            <ul class="flex items-center gap-5">
                                <?php
                                $social_links = get_field('contact_details')['social_links']; ?>
                                <?php if ($social_links['x_twitter']) { ?>
                                    <li><a href="<?php echo esc_url($social_links['x_twitter']); ?>"><img src="<?php echo get_template_directory_uri() . '/assets/images/twitter-icon.png'; ?>" alt="twitter-icon" /></a></li>
                                <?php } ?>
                                <?php if ($social_links['instagram']) { ?>
                                    <li><a href="<?php echo esc_url($social_links['instagram']); ?>"><img src="<?php echo get_template_directory_uri() . '/assets/images/insta-icon.png'; ?>" alt="insta-icon" /></a></li>
                                <?php } ?>
                                <?php if ($social_links['facebook']) { ?>
                                    <li><a href="<?php echo esc_url($social_links['facebook']); ?>"><img src="<?php echo get_template_directory_uri() . '/assets/images/facebook-icon.png'; ?>" alt="facebook-icon" /></a></li>
                                <?php } ?>
                                <?php if ($social_links['youtube']) { ?>
                                    <li><a href="<?php echo esc_url($social_links['youtube']); ?>"><img src="<?php echo get_template_directory_uri() . '/assets/images/youtube-icon.png'; ?>" alt="youtube-icon" /></a></li>
                                <?php } ?>
                            </ul>
                        </div>
                    </div>

                    <div class="bg-primary p-6 xl:p-8 rounded-xl">
                        <h3 class="text-2xl mb-4">Request a Quote</h3>
                        <?php echo do_shortcode('[contact-form-7 id="b736648" title="Request Quote"]'); ?>
                    </div>

                </aside>
            </div>
        </main>
    </div>
</section>


<?php
$current_post_id = get_the_ID();
$post_type = 'company';

$category_terms = wp_get_post_terms($current_post_id, 'item_category', ['fields' => 'ids']);
$tag_terms      = wp_get_post_terms($current_post_id, 'item_tag', ['fields' => 'ids']);

$tax_query = [];

if (!empty($category_terms)) {
    $tax_query[] = [
        'taxonomy' => 'item_category',
        'field'    => 'term_id',
        'terms'    => $category_terms,
    ];
}

if (!empty($tag_terms)) {
    $tax_query[] = [
        'taxonomy' => 'item_tag',
        'field'    => 'term_id',
        'terms'    => $tag_terms,
    ];
}

if (count($tax_query) > 1) {
    $tax_query['relation'] = 'OR';
}

// Initial query: get related companies
$related_args = [
    'post_type'      => $post_type,
    'post__not_in'   => [$current_post_id],
    'posts_per_page' => 6,
    'tax_query'      => $tax_query,
];

$related_query = new WP_Query($related_args);

// Fallback: If no related posts, get 6 random companies
if (!$related_query->have_posts()) {
    $related_query = new WP_Query([
        'post_type'      => $post_type,
        'post__not_in'   => [$current_post_id],
        'posts_per_page' => 6,
        'orderby'        => 'rand',
    ]);
}
?>
<?php if ($related_query->have_posts()) : ?>
    <section
        class="manufacture bg-primary py-space relative before:content-[''] before:w-28 before:h-16 before:bg-[url('<?php echo get_template_directory_uri() . '/assets/images/kitchen-aid-cloud.png' ?>')] before:bg-no-repeat before:bg-cover before:absolute before:bottom-0 before:right-0 before:z-20">
        <div class="container">
            <div class="heading-wrap lg:mb-10 mb-6 text-center">
                <h2 class="title text-3xl xl:text-4xl font-bold text-center lg:leading-snug"><span class="font-normal">Find Related </span>Manufactures</h2>
            </div>
            <div class="owl-carousel manufacutre-slider">
                <?php while ($related_query->have_posts()) : $related_query->the_post(); ?>
                    <?php
                    $city             = get_field('city');
                    $state            = get_field('state');
                    $company_images   = get_field('company_images');
                    ?>
                    <div class="item">
                        <div class="relative rounded-2xl bg-white p-2 flex flex-wrap flex-col">
                            <div class="block rounded-2xl overflow-hidden">
                                <a href="<?php the_permalink(); ?>">
                                    <img class="w-full" src="<?php echo $company_images[0]['url']; ?>" alt="<?php echo $company_images[0]['alt']; ?>" />
                                </a>
                            </div>
                            <div class="pt-6 px-4">
                                <h2 class="text-2xl font-bold mb-2"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                <p class="mb-3 flex items-center"><img class="me-2 w-2" src="<?php echo get_template_directory_uri() . '/assets/images/location-icon.svg'; ?>" alt="location-icon" /><?php echo $city . ', ' . $state; ?></p>
                                <?php
                                $company_id = get_the_ID(); // Assuming this is inside the single company template

                                $args = [
                                    'post_type'      => 'review',
                                    'post_status'    => 'publish',
                                    'posts_per_page' => -1,
                                    'meta_query'     => [
                                        [
                                            'key'   => 'company_id',
                                            'value' => $company_id,
                                            'compare' => '='
                                        ]
                                    ]
                                ];

                                $reviews = get_posts($args);
                                $total_reviews = count($reviews);
                                $total_rating = 0;

                                foreach ($reviews as $review) {
                                    $rating = get_post_meta($review->ID, 'rating', true);
                                    $total_rating += intval($rating);
                                }

                                $average_rating = $total_reviews > 0 ? round($total_rating / $total_reviews, 1) : 0;

                                // Convert average rating (out of 5) to percentage for width
                                $filled_width = ($average_rating / 5) * 100;
                                ?>
                                <div class="flex items-center mb-4"> <span class="inline-block mr-2">
                                        <div class="stars text-primary flex text-[15px]">
                                            <div class="rating-stars relative">
                                                <div class="empty stars text-gray-dark flex">
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                </div>
                                                <div class="filled stars text-primary flex absolute top-0 left-0 overflow-hidden" style="width: <?php echo $filled_width; ?>%">
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </span>
                                    <p class="text-sm font-semibold"><?php echo $total_reviews; ?> Review<?php echo $total_reviews <= 1 ? '' : 's'; ?></p>
                                </div>
                                <?php
                                $categories = get_the_terms(get_the_ID(), 'item_category');
                                if (!empty($categories) && !is_wp_error($categories)) : ?>
                                    <div class="mb-4">
                                        <ul class="grid grid-cols-1 font-medium gap-2 text-sm">
                                            <?php foreach ($categories as $term) : ?>
                                                <li class="flex items-center"><img class="me-2" src="<?php echo get_template_directory_uri() . '/assets/images/check-circle.svg'; ?>" alt="check-circle" /><?php echo esc_html($term->name); ?></li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="p-4 pb-6 pt-0 mt-auto">
                                <a class="btn bg-primary" href="<?php the_permalink(); ?>">Request price</a>
                            </div>
                        </div>
                    </div>
                <?php endwhile;
                wp_reset_postdata(); ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php get_footer(); ?>