jQuery(function ($) {
  let stateCityData = {};

  // Fetch state-city data from JSON
  $.getJSON(acfStateCity.json_url, function (data) {
    stateCityData = data;

    // Populate state dropdown
    const $stateField = $(".location__state select");
    $stateField.empty().append('<option value="">Select State</option>');
    $.each(stateCityData, function (state) {
      $stateField.append(`<option value="${state}">${state}</option>`);
    });

    // Populate cities when state changes
    $stateField.on("change", function () {
      const selectedState = $(this).val();
      const $cityField = $(".location__city select");
      $cityField.empty().append('<option value="">Select City</option>');

      if (stateCityData[selectedState]) {
        $.each(stateCityData[selectedState], function (i, city) {
          $cityField.append(`<option value="${city}">${city}</option>`);
        });
      }
    });
  });
});
