<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package kiresu
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
	<?php wp_head(); ?>
</head>

<body <?php body_class('font-Poppins'); ?>>
	<?php wp_body_open(); ?>
	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'kiresu'); ?></a>

		<!-- Top Bar -->
		<div class="bg-secondary py-2 md:py-3 text-xs md:text-sm">
			<div class="container">
				<ul class="flex justify-end font-medium space-x-6">
					<li class="flex items-center"><img class="mr-2" src="<?php echo get_template_directory_uri() . '/assets/images/mail-icon.svg'; ?>" title="mail-icon" alt="mail-icon"><a class="text-black" href="mailto:<?php echo get_field('top_bar_details', 'options')['email']; ?>"><?php echo get_field('top_bar_details', 'options')['email']; ?></a></li>
					<li class="flex items-center"><img class="mr-2" src="<?php echo get_template_directory_uri() . '/assets/images/call-icon.svg'; ?>" title="call-icon" alt="call-icon"><a class="text-black" href="tel:<?php echo get_field('top_bar_details', 'options')['phone']; ?>"><?php echo get_field('top_bar_details', 'options')['phone']; ?></a></li>
				</ul>
			</div>
		</div>

		<header id="masthead" class="bg-white py-3 z-10 relative">
			<div class="container">
				<div class="mx-auto flex justify-between items-center">
					<!-- Logo -->
					<div class="flex items-center justify-between lg:flex-row relative md:top-[-0.8em] md:before:content md:before:absolute md:before:w-[12rem] xl:before:w-[15rem] md:before:h-[5rem] md:before:bg-white md:before:left-[-2.2rem] md:before:top-[-1.5rem] md:before:-z-10 md:before:rounded-10*5">
						<a href="<?php echo site_url(); ?>">
							<img class="w-[8rem] xl:w-[11rem]" src="<?php echo get_field('header_logo', 'options')['url']; ?>" title="<?php echo get_field('header_logo', 'options')['title']; ?>" alt="<?php echo get_field('header_logo', 'options')['alt']; ?>" />
						</a>
					</div>

					<!-- Desktop Menu -->
					<?php
					wp_nav_menu([
						'theme_location' => 'primary',
						'container'      => 'nav',
						'container_class' => 'hidden lg:block',
						'menu_class'     => 'md:flex space-x-8 xl:space-x-14 2xl:text-lg items-center py-2 font-medium',
						'walker'         => new Custom_Dropdown_Walker(),
					]);


					?>

					<div class="lg:flex items-center hidden lg:justify-center gap-2">
						<a class="bg-primary btn" href="<?php echo get_field('request_quote_button', 'options')['url']; ?>"><?php echo get_field('request_quote_button', 'options')['title']; ?></a>
					</div>

					<!-- Mobile Menu Button -->
					<div class="lg:hidden">
						<button id="menu-toggle" class="focus:outline-none border-0">
							<svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
								<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
									d="M4 6h16M4 12h16M4 18h16" />
							</svg>
						</button>
					</div>
				</div>

				<!-- Mobile Menu -->
				<?php
				wp_nav_menu([
					'theme_location' => 'primary',
					'container'      => 'div',
					'container_id'   => 'mobile-menu',
					'container_class' => 'lg:hidden max-h-0 overflow-hidden transition-max-height duration-300 space-y-2',
					'menu_class'     => 'space-y-2 pt-8',
					'walker'         => new Mobile_Dropdown_Walker(),
				]);
				?>

			</div>
		</header><!-- #masthead -->