<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package kiresu
 */

get_header();
?>

<main id="primary" class="site-main">

	<?php
	$category_banner_url = get_field('common_banner_image', 'options')['url'];
	?>
	<section class="banner bg-cover bg-no-repeat flex h-[21rem] items-center relative w-full" style="background: url(<?php echo $category_banner_url; ?>) no-repeat;background-position: top;background-size: cover;">
		<div class="container relative top-[-1.5rem]">
			<div class="flex justify-center items-center">
				<div class="text-center flex flex-wrap flex-col">
					<h1 class="mb-3 font-bold text-4xl xl:text-5xl 2xl:text-7xl text-white uppercase leading-none">404</h1>
				</div>
			</div>
		</div>
	</section>

	<?php
	echo do_shortcode('[custom_breadcrumbs]');
	?>

	<section class="py-space pt-0">
		<div class="container">
			<div class="heading-wrap lg:mb-10 mb-6">
				<h2 class="title text-3xl xl:text-4xl font-bold text-center lg:leading-snug">Oops! That page can&rsquo;t be found.</h2>
			</div>
		</div>
	</section>

	<section class="discover-section relative mt-[-7.8rem] md:mt-[-4.5rem] lg:mb-10 mb-6">
		<div class="container">
			<?php echo do_shortcode('[custom_search_form]'); ?>
		</div>
	</section>
</main><!-- #main -->

<?php
get_footer();
